% Script to generate Figure 2

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)

% Generate data
load RandEx1.mat
rng(239843)
n_true = length(A);
T = 1000;
t_eval = 0:T;

U = randn(T+1,1);
Y = runDTSys(A,B,C,D,U,t_eval);

% select points to recover
num = 100;
log_min_freq = -3;
freqs = logspace(log_min_freq,log10(.99*pi),num);
z = exp(1i*freqs);


%% Recover transfer function values
clear opts
opts.num_windows = 20;
opts.num_windows_keep = 10;
opts.n = n_true;
tic
[Hz,nstd_Hz,cond_nums,residuals,opts] = CalculateTFVals(U,Y,z,opts);
toc
%% Calculate true values for comparison
I = eye(length(A));
H = @(s) C*((s*I-A)\B);
H_true = zeros(num,1);
parfor i = 1:num
    H_true(i) = H(z(i));
end
%% Calculate and report error
err = abs(Hz(:,1)-H_true);
err2 = norm(err);
err2rel = norm(err)/norm(H_true);

fprintf('2-norm error in TF estimates         : %.5e\n',err2)
fprintf('Relative 2-norm error in TF estimates: %.5e\n',err2rel)
%% plot relative error and standard deviation
f=figure;
f.Position = [476 445 700 280];
relerr = abs(Hz(:,1)-H_true)./abs(H_true);
loglog(freqs,relerr,'LineWidth',2)
hold on
loglog(freqs,nstd_Hz(:,1),'LineWidth',2)
legend('$\epsilon_{rel}$','$s_W$','Interpreter','latex')
ax = gca;
Default_TW = ax.TickLength;
Default_LW = ax.LineWidth;
ax.TickLength = Default_TW * 2;
ax.LineWidth = Default_LW * 2;
ax.FontSize = 16;
xlim([10^-3,pi])
xticks([10^-3, 10^-2, 10^-1, 10^0, pi])
xticklabels({'10^{-3}', '10^{-2}', '10^{-1}', '10^0', '\pi'})
xlabel('$\omega$','interpreter','latex','fontsize',25)
ylabel('$s_W$, $\epsilon_{rel}$','interpreter','latex','fontsize',25)